setwd("P:/JK Australia Manuscripts")
POPBIOMASS<-read.csv("POP_GAS_EXCHANGE_CHARTS.csv",sep=",", header=TRUE)
names(POPBIOMASS)
str(POPBIOMASS)
POPBIOMASS$H2O<-factor(POPBIOMASS$H2O,levels=c("D","ND"))
POPBIOMASS$CO2<-factor(POPBIOMASS$CO2,levels=c("E","A"))
#POPBIOMASS$M<-factor(POPBIOMASS$M,levels=c("A","B"))
#POPBIOMASS$Species<-factor(POPBIOMASS$Species,levels=c("POP","POP"))

#par(xaxs="i")
windows(width=10, height=5) 
#par(mfrow=c(1,2))
par(las=1)
#(bottom, left, top, right)
par(mfrow=c(1,2), omi=c(.5, 0.75, 0.75, .5)) 
par(mar=c(2, 2, 0, 0.25))
par(xaxs="i")
#A
with(POPBIOMASS, plot(A[ST=="POPEND"]~SWC[ST=="POPEND"],col="red",
                      pch=16,xlim=c(0,0.35),ylim=c(0,30),xlab="",ylab="",cex.axis=1.25))
with(POPBIOMASS,points(A[ST=="POPED"]~SWC[ST=="POPED"],col="red"))
with(POPBIOMASS,points(A[ST=="POPAND"]~SWC[ST=="POPAND"],col="blue",pch=16))
with(POPBIOMASS,points(A[ST=="POPAD"]~SWC[ST=="POPAD"],col="blue"))
with(POPBIOMASS,legend("topleft", legend=c(expression(aC[a]-W,aC[a]-D,eC[a]-W,eC[a]-D)),bty="n",pch=c(16,1,16,1),pt.cex=1.25,col=c("blue","blue","red","red")))
mtext(side = 1, text =expression(bold(s.w.c.~(kg~kg^-1))), line = 2.75,font=2, cex=1.25)
par(las=3)
mtext(side = 2, text =expression(bold(A[sat]~(mu*mol~m^-2~s^-1))), line = 2.5,font=2, cex=1.25)

#(bottom, left, top, right)
par(mar=c(2, 0.25, 0, 2))
par(las=1)
#gs
with(POPBIOMASS, plot(GS[ST=="POPEND"]~SWC[ST=="POPEND"],col="red",
                      pch=16,xlim=c(0,0.35),ylim=c(0,0.5),xlab="",ylab="",yaxt="n",cex.axis=1.25))
with(POPBIOMASS,points(GS[ST=="POPED"]~SWC[ST=="POPED"],col="red"))
with(POPBIOMASS,points(GS[ST=="POPAND"]~SWC[ST=="POPAND"],col="blue",pch=16))
with(POPBIOMASS,points(GS[ST=="POPAD"]~SWC[ST=="POPAD"],col="blue"))
with(POPBIOMASS,legend("topleft", legend=c(expression(aC[a]-W,aC[a]-D,eC[a]-W,eC[a]-D)),bty="n",pch=c(16,1,16,1),pt.cex=1.25,col=c("blue","blue","red","red")))
mtext(side = 1, text =expression(bold(s.w.c.~(kg~kg^-1))), line = 2.75,font=2, cex=1.25)
par(las=3)
mtexti(text =expression(bold(g[s]~(mol~m^-2~s^-1))),font=2,cex=1.25, 4)
#mtext(side = 4, text =expression(bold(g[s]~(mol~m^-2~s^-1))), line = 2.5,font=2, cex=1.25)
par(las=1)
axis(4,labels=TRUE,cex.axis=1.25)
mtext(expression(bold(italic(Eucalyptus~populnea))),outer=TRUE,font=2,line=1.5,cex=1.25)

